/*
 * Decompiled with CFR 0.152.
 */
package com.github.charlyb01.music_control.mixin;

import com.github.charlyb01.music_control.Utils;
import com.github.charlyb01.music_control.categories.Music;
import com.github.charlyb01.music_control.categories.MusicCategories;
import com.github.charlyb01.music_control.categories.MusicIdentifier;
import com.github.charlyb01.music_control.client.MusicControlClient;
import com.github.charlyb01.music_control.config.ModConfig;
import com.github.charlyb01.music_control.imixin.PauseResumeIMixin;
import java.util.HashSet;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1142;
import net.minecraft.class_1144;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_5195;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1142.class})
public abstract class MusicTrackerMixin {
    @Shadow
    @Final
    private class_310 field_5575;
    @Shadow
    @Final
    private class_5819 field_5571;
    @Shadow
    private int field_5572;
    @Shadow
    private class_1113 field_5574;
    @Unique
    private boolean displayPrompted = false;

    @Shadow
    public abstract void method_4858(class_5195 var1);

    @Inject(method={"play"}, at={@At(value="HEAD")}, cancellable=true)
    private void playMusic(class_5195 type, CallbackInfo ci) {
        class_2960 eventId = type != null ? ((class_3414)type.method_27279().comp_349()).method_14833() : null;
        MusicControlClient.inCustomTracking = false;
        if (!MusicControlClient.init || this.field_5575.field_1687 == null) {
            return;
        }
        if (!MusicControlClient.shouldPlay) {
            MusicControlClient.shouldPlay = true;
            this.field_5572 = Utils.getTimer(this.field_5571);
            ci.cancel();
            return;
        }
        boolean wasPlaying = this.field_5575.method_1483().method_4877(this.field_5574);
        this.field_5575.method_1483().method_4870(this.field_5574);
        if (MusicControlClient.musicSelected != null) {
            MusicControlClient.currentMusic = MusicControlClient.musicSelected;
            MusicControlClient.musicSelected = null;
        } else if (MusicControlClient.previousMusic) {
            class_2960 music;
            MusicControlClient.previousMusic = false;
            if (wasPlaying) {
                MusicCategories.PLAYED_MUSICS.pollLast();
            }
            if ((music = MusicCategories.PLAYED_MUSICS.peekLast()) != null) {
                MusicControlClient.currentMusic = music;
            }
        } else if (!MusicControlClient.loopMusic) {
            if (eventId != null && MusicControlClient.currentCategory.equals("default") && Music.MUSIC_BY_EVENT.containsKey(eventId)) {
                boolean creative = this.field_5575.field_1724 != null && this.field_5575.field_1724.method_7337();
                HashSet<Music> musics = MusicIdentifier.getListFromEvent(eventId, (class_1657)this.field_5575.field_1724, (class_1937)this.field_5575.field_1687, this.field_5571);
                MusicControlClient.currentMusic = musics.isEmpty() ? MusicIdentifier.getFallback((class_5321<class_1937>)this.field_5575.field_1687.method_27983(), creative, this.field_5571) : MusicIdentifier.getFromList(musics, this.field_5571);
            } else {
                MusicControlClient.currentMusic = MusicIdentifier.getFromCategory(this.field_5571);
            }
        }
        if (MusicControlClient.currentMusic != null || type != null) {
            this.field_5574 = class_1109.method_4759((class_3414)(MusicControlClient.currentMusic == null ? (class_3414)type.method_27279().comp_349() : class_3414.method_47908((class_2960)MusicControlClient.currentMusic)));
        }
        if (this.field_5574.method_4776() != class_1144.field_5592) {
            this.field_5575.method_1483().method_4873(this.field_5574);
            MusicControlClient.inCustomTracking = true;
        }
        this.displayMusic();
        this.field_5572 = Utils.getTimer(this.field_5571);
        ci.cancel();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleMusic(CallbackInfo ci) {
        this.handlePreviousMusicKey();
        this.handleNextMusicKey();
        this.handleResumePauseKey();
        this.handleChangeCategoryKey();
        this.handleDisplayMusicKey();
        if (MusicControlClient.inCustomTracking) {
            if (this.field_5575 == null || !MusicControlClient.init || this.field_5575.field_1687 == null || this.field_5574 == null || !this.field_5575.method_1483().method_4877(this.field_5574)) {
                MusicControlClient.inCustomTracking = false;
            } else {
                ci.cancel();
            }
        }
        if (MusicControlClient.isPaused && (this.field_5574 == null || this.field_5575 != null && !this.field_5575.method_1483().method_4877(this.field_5574))) {
            ++this.field_5572;
        }
    }

    @Unique
    private void displayMusic() {
        if (ModConfig.get().cosmetics.display.atMusicStart || MusicControlClient.categoryChanged) {
            this.printMusic();
        }
        if (MusicControlClient.categoryChanged) {
            MusicControlClient.categoryChanged = false;
        }
    }

    @Unique
    private void printPaused() {
        Utils.print(this.field_5575, (class_2561)class_2561.method_43471((String)"music.paused"));
    }

    @Unique
    private void printMusic() {
        String currentMusic;
        if (this.field_5575.field_1687 == null) {
            return;
        }
        String string = currentMusic = this.field_5574 == null || this.field_5574.method_4776() == null ? Music.EMPTY_MUSIC : this.field_5574.method_4776().method_4767().toString();
        if (currentMusic.equals(Music.EMPTY_MUSIC)) {
            if (!this.displayPrompted) {
                return;
            }
            this.displayPrompted = false;
            if (ModConfig.get().cosmetics.display.remainingSeconds) {
                double remaining = (double)this.field_5572 / 20.0;
                Utils.print(this.field_5575, (class_2561)class_2561.method_43469((String)"music.no_playing_with_time", (Object[])new Object[]{String.valueOf(remaining)}));
            } else {
                Utils.print(this.field_5575, (class_2561)class_2561.method_43471((String)"music.no_playing"));
            }
        } else {
            class_5250 category = class_2561.method_48321((String)("music.category." + MusicControlClient.currentCategory), (String)MusicControlClient.currentCategory.toUpperCase().replace('_', ' '));
            class_5250 music = class_2561.method_43471((String)currentMusic);
            class_5250 content = MusicControlClient.categoryChanged ? class_2561.method_43469((String)"music.format.category", (Object[])new Object[]{category, music}) : music;
            Utils.print(this.field_5575, (class_2561)class_2561.method_43469((String)"record.nowPlaying", (Object[])new Object[]{content}));
        }
    }

    @Unique
    private void handlePreviousMusicKey() {
        if (MusicControlClient.previousMusic) {
            if (MusicControlClient.isPaused) {
                MusicControlClient.previousMusic = false;
                this.printPaused();
            } else {
                this.displayPrompted = ModConfig.get().cosmetics.display.atMusicStart;
                this.method_4858(null);
            }
        }
    }

    @Unique
    private void handleNextMusicKey() {
        if (MusicControlClient.nextMusic) {
            MusicControlClient.nextMusic = false;
            MusicControlClient.loopMusic = false;
            if (MusicControlClient.isPaused) {
                this.printPaused();
            } else {
                this.displayPrompted = ModConfig.get().cosmetics.display.atMusicStart;
                this.method_4858(this.field_5575.method_1544());
            }
        }
    }

    @Unique
    private void handleResumePauseKey() {
        if (MusicControlClient.pauseResume) {
            MusicControlClient.pauseResume = false;
            if (MusicControlClient.isPaused) {
                MusicControlClient.isPaused = false;
                ((PauseResumeIMixin)this.field_5575.method_1483()).music_control$resumeMusic();
                if (this.field_5575.field_1724 != null) {
                    Utils.print(this.field_5575, (class_2561)class_2561.method_43471((String)"music.play"));
                }
            } else {
                MusicControlClient.isPaused = true;
                ((PauseResumeIMixin)this.field_5575.method_1483()).music_control$pauseMusic();
                if (this.field_5575.field_1724 != null) {
                    Utils.print(this.field_5575, (class_2561)class_2561.method_43471((String)"music.pause"));
                }
            }
        }
    }

    @Unique
    private void handleChangeCategoryKey() {
        if (MusicControlClient.nextCategory || MusicControlClient.previousCategory) {
            if (MusicControlClient.isPaused) {
                this.printPaused();
            } else {
                MusicControlClient.categoryChanged = true;
                MusicCategories.changeCategory(MusicControlClient.nextCategory);
                this.method_4858(this.field_5575.method_1544());
            }
            if (MusicControlClient.nextCategory) {
                MusicControlClient.nextCategory = false;
            } else {
                MusicControlClient.previousCategory = false;
            }
        }
    }

    @Unique
    private void handleDisplayMusicKey() {
        if (MusicControlClient.printMusic) {
            MusicControlClient.printMusic = false;
            this.displayPrompted = true;
            this.printMusic();
        }
    }
}

